<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class DatabaseSeeder extends Seeder
{
    public function run()
    {
        $users = [
            [
                'name'     => 'Super Admin',
                'email'    => 'superadmin@taskflow.com',
                'username' => 'superadmin',
                'role'     => 'super_admin',
                'phone'    => '0300-0000001',
                'status'   => 'active',
                'password' => Hash::make('password'),
            ],
            [
                'name'     => 'Admin User',
                'email'    => 'admin@taskflow.com',
                'username' => 'admin',
                'role'     => 'admin',
                'phone'    => '0300-0000002',
                'status'   => 'active',
                'password' => Hash::make('password'),
            ],
            [
                'name'     => 'Marketing Manager',
                'email'    => 'marketing@taskflow.com',
                'username' => 'marketing',
                'role'     => 'marketing',
                'phone'    => '0300-0000003',
                'status'   => 'active',
                'password' => Hash::make('password'),
            ],
            [
                'name'     => 'Ali Designer',
                'email'    => 'designer@taskflow.com',
                'username' => 'designer',
                'role'     => 'designer',
                'phone'    => '0300-0000004',
                'status'   => 'active',
                'password' => Hash::make('password'),
            ],
            [
                'name'     => 'Ahmed Developer',
                'email'    => 'developer@taskflow.com',
                'username' => 'developer',
                'role'     => 'developer',
                'phone'    => '0300-0000005',
                'status'   => 'active',
                'password' => Hash::make('password'),
            ],
        ];

        foreach ($users as $userData) {
            User::updateOrCreate(
                ['email' => $userData['email']],
                $userData
            );
        }

        $this->command->info('✅ All users seeded successfully!');
        $this->command->table(
            ['Name', 'Email', 'Role', 'Password'],
            collect($users)->map(fn($u) => [$u['name'], $u['email'], $u['role'], 'password'])->toArray()
        );
    }
}
