@extends('layouts.app')
@section('title', 'Approval History')
@section('page-title', 'Approval History')

@section('content')
<div class="card">
    <div class="card-header py-3">
        <i class="bi bi-archive me-2 text-success"></i>Approval History
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table mb-0">
                <thead>
                    <tr>
                        <th class="ps-3">Task</th>
                        <th>Assigned To</th>
                        <th>Reviewed By</th>
                        <th>Decision</th>
                        <th>Comment</th>
                        <th>Date</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($approvals as $approval)
                    <tr>
                        <td class="ps-3">
                            <a href="{{ route('tasks.show', $approval->task) }}" class="fw-medium text-decoration-none small">
                                {{ Str::limit($approval->task->title, 35) }}
                            </a>
                        </td>
                        <td>
                            <small>{{ $approval->task->assignedUser->name }}</small>
                        </td>
                        <td>
                            <div class="d-flex align-items-center gap-1">
                                <div class="avatar" style="width:26px;height:26px;font-size:0.65rem;">
                                    {{ strtoupper(substr($approval->reviewer->name, 0, 1)) }}
                                </div>
                                <small>{{ $approval->reviewer->name }}</small>
                            </div>
                        </td>
                        <td>
                            <span class="badge bg-{{ $approval->status === 'approved' ? 'success' : 'danger' }}">
                                {{ ucfirst($approval->status) }}
                            </span>
                        </td>
                        <td><small class="text-muted">{{ Str::limit($approval->comment, 50) ?? '—' }}</small></td>
                        <td><small class="text-muted">{{ $approval->created_at->format('d M Y, h:i A') }}</small></td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="6" class="text-center py-5 text-muted">
                            No approval history found.
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
    @if($approvals->hasPages())
    <div class="card-footer">{{ $approvals->links() }}</div>
    @endif
</div>
@endsection
