@extends('layouts.app')
@section('title', 'Pending Approvals')
@section('page-title', 'Pending Approvals')

@section('content')
<div class="card">
    <div class="card-header py-3 d-flex justify-content-between align-items-center">
        <span><i class="bi bi-clipboard-check me-2 text-warning"></i>Tasks Awaiting Approval</span>
        <span class="badge bg-warning text-dark">{{ $tasks->total() }} Pending</span>
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table mb-0">
                <thead>
                    <tr>
                        <th class="ps-3">Task</th>
                        <th>Assigned To</th>
                        <th>Priority</th>
                        <th>Completed At</th>
                        <th>Planned End</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($tasks as $task)
                    <tr>
                        <td class="ps-3">
                            <a href="{{ route('tasks.show', $task) }}" class="fw-semibold text-decoration-none">
                                {{ Str::limit($task->title, 40) }}
                            </a>
                            @if($task->description)
                            <div class="text-muted small">{{ Str::limit($task->description, 60) }}</div>
                            @endif
                        </td>
                        <td>
                            <div class="d-flex align-items-center gap-2">
                                <div class="avatar">{{ strtoupper(substr($task->assignedUser->name, 0, 1)) }}</div>
                                <div>
                                    <div class="small fw-medium">{{ $task->assignedUser->name }}</div>
                                    <span class="role-badge role-{{ $task->assignedUser->role }}">
                                        {{ str_replace('_', ' ', $task->assignedUser->role) }}
                                    </span>
                                </div>
                            </div>
                        </td>
                        <td>
                            <span class="badge bg-{{ $task->priorityBadge() }}">{{ $task->priority }}</span>
                        </td>
                        <td>
                            <small class="text-muted">
                                {{ $task->actual_end ? $task->actual_end->format('d M Y h:i A') : '—' }}
                            </small>
                        </td>
                        <td>
                            <small class="{{ $task->planned_end->isPast() ? 'text-danger fw-bold' : 'text-muted' }}">
                                {{ $task->planned_end->format('d M Y') }}
                            </small>
                        </td>
                        <td>
                            <div class="d-flex gap-1">
                                <a href="{{ route('tasks.show', $task) }}" class="btn btn-sm btn-outline-primary" title="View Details">
                                    <i class="bi bi-eye"></i>
                                </a>
                                <!-- Quick Approve -->
                                <form action="{{ route('approvals.approve', $task) }}" method="POST"
                                      onsubmit="return confirm('Approve this task?')">
                                    @csrf
                                    <button class="btn btn-sm btn-success" title="Approve">
                                        <i class="bi bi-check-lg"></i>
                                    </button>
                                </form>
                                <!-- Reject -->
                                <button class="btn btn-sm btn-danger" title="Reject"
                                        data-bs-toggle="modal" data-bs-target="#rejectModal{{ $task->id }}">
                                    <i class="bi bi-x-lg"></i>
                                </button>
                            </div>
                        </td>
                    </tr>

                    <!-- Reject Modal for each task -->
                    <div class="modal fade" id="rejectModal{{ $task->id }}" tabindex="-1">
                        <div class="modal-dialog">
                            <form action="{{ route('approvals.reject', $task) }}" method="POST">
                                @csrf
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title text-danger">
                                            <i class="bi bi-x-circle me-2"></i>Reject Task
                                        </h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                    </div>
                                    <div class="modal-body">
                                        <p class="text-muted">Task: <strong>{{ $task->title }}</strong></p>
                                        <div class="mb-3">
                                            <label class="form-label fw-semibold">
                                                Rejection Reason <span class="text-danger">*</span>
                                            </label>
                                            <textarea name="comment" class="form-control" rows="3"
                                                      placeholder="Explain the reason for rejection..." required></textarea>
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                        <button type="submit" class="btn btn-danger">
                                            <i class="bi bi-x-circle me-1"></i>Reject
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                    @empty
                    <tr>
                        <td colspan="6" class="text-center py-5 text-muted">
                            <i class="bi bi-check-all display-5 d-block mb-3 opacity-50 text-success"></i>
                            <h6>All caught up! No tasks pending approval.</h6>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
    @if($tasks->hasPages())
    <div class="card-footer">{{ $tasks->links() }}</div>
    @endif
</div>
@endsection
