@extends('layouts.app')
@section('title', 'My Dashboard')
@section('page-title', 'My Dashboard')

@section('content')
<!-- Welcome Banner -->
<div class="card mb-4" style="background:linear-gradient(135deg,#6366f1,#8b5cf6);border:none;color:#fff;">
    <div class="card-body py-4">
        <div class="d-flex align-items-center gap-3">
            <div style="width:60px;height:60px;background:rgba(255,255,255,0.2);border-radius:50%;display:flex;align-items:center;justify-content:center;font-size:1.6rem;font-weight:700;">
                {{ strtoupper(substr(auth()->user()->name, 0, 1)) }}
            </div>
            <div>
                <h5 class="mb-0">Welcome back, {{ auth()->user()->name }}! 👋</h5>
                <small class="opacity-75">
                    <span class="text-capitalize">{{ str_replace('_', ' ', auth()->user()->role) }}</span>
                    &bull; {{ now()->format('l, d F Y') }}
                </small>
            </div>
        </div>
    </div>
</div>

<!-- Stats -->
<div class="row g-3 mb-4">
    <div class="col-6 col-md-3">
        <div class="stat-card bg-white text-center">
            <div class="stat-icon mx-auto mb-2" style="background:#e0e7ff;color:#6366f1;">
                <i class="bi bi-list-task"></i>
            </div>
            <div class="fw-bold fs-3">{{ $stats['total'] }}</div>
            <div class="text-muted small">Total Tasks</div>
        </div>
    </div>
    <div class="col-6 col-md-3">
        <div class="stat-card bg-white text-center">
            <div class="stat-icon mx-auto mb-2" style="background:#f1f5f9;color:#64748b;">
                <i class="bi bi-hourglass"></i>
            </div>
            <div class="fw-bold fs-3 text-secondary">{{ $stats['pending'] }}</div>
            <div class="text-muted small">Pending</div>
        </div>
    </div>
    <div class="col-6 col-md-3">
        <div class="stat-card bg-white text-center">
            <div class="stat-icon mx-auto mb-2" style="background:#dbeafe;color:#2563eb;">
                <i class="bi bi-play-circle"></i>
            </div>
            <div class="fw-bold fs-3 text-primary">{{ $stats['in_progress'] }}</div>
            <div class="text-muted small">In Progress</div>
        </div>
    </div>
    <div class="col-6 col-md-3">
        <div class="stat-card bg-white text-center">
            <div class="stat-icon mx-auto mb-2" style="background:#dcfce7;color:#16a34a;">
                <i class="bi bi-check-circle"></i>
            </div>
            <div class="fw-bold fs-3 text-success">{{ $stats['completed'] }}</div>
            <div class="text-muted small">Completed</div>
        </div>
    </div>
</div>

<!-- Task List -->
<div class="card">
    <div class="card-header py-3 d-flex justify-content-between align-items-center">
        <span><i class="bi bi-list-check me-2"></i>My Tasks</span>
        <a href="{{ route('tasks.create') }}" class="btn btn-sm btn-primary">
            <i class="bi bi-plus-circle me-1"></i> Add Task
        </a>
    </div>
    <div class="card-body p-0">
        @forelse($tasks as $task)
        <div class="p-3 border-bottom {{ $task->isOverdue() ? 'bg-danger-subtle' : '' }}">
            <div class="d-flex align-items-start gap-3">
                <!-- Status Icon -->
                <div class="flex-shrink-0 mt-1">
                    @if($task->status === 'approved')
                        <i class="bi bi-check-circle-fill text-success fs-5"></i>
                    @elseif($task->status === 'in_progress')
                        <i class="bi bi-play-circle-fill text-primary fs-5"></i>
                    @elseif($task->status === 'under_review')
                        <i class="bi bi-eye-fill text-warning fs-5"></i>
                    @elseif($task->status === 'rejected')
                        <i class="bi bi-x-circle-fill text-danger fs-5"></i>
                    @else
                        <i class="bi bi-circle text-secondary fs-5"></i>
                    @endif
                </div>

                <!-- Task Info -->
                <div class="flex-grow-1">
                    <div class="d-flex align-items-center gap-2 flex-wrap">
                        <a href="{{ route('tasks.show', $task) }}" class="fw-semibold text-decoration-none">
                            {{ $task->title }}
                        </a>
                        <span class="badge bg-{{ $task->priorityBadge() }} small">{{ $task->priority }}</span>
                        <span class="badge status-{{ $task->status }} small">
                            {{ str_replace('_', ' ', ucfirst($task->status)) }}
                        </span>
                        @if($task->isOverdue())
                            <span class="badge bg-danger small">OVERDUE</span>
                        @endif
                    </div>

                    @if($task->description)
                    <div class="text-muted small mt-1">{{ Str::limit($task->description, 80) }}</div>
                    @endif

                    <div class="d-flex gap-3 mt-1">
                        <small class="text-muted">
                            <i class="bi bi-calendar me-1"></i>
                            {{ $task->planned_start->format('d M') }} — {{ $task->planned_end->format('d M Y') }}
                        </small>
                        @if($task->actual_start)
                        <small class="text-muted">
                            <i class="bi bi-play me-1"></i>Started: {{ $task->actual_start->format('d M Y h:i A') }}
                        </small>
                        @endif
                    </div>

                    @if($task->status === 'rejected' && $task->rejection_reason)
                    <div class="alert alert-danger py-1 px-2 mt-2 small mb-0">
                        <i class="bi bi-exclamation-triangle me-1"></i>
                        Rejection Reason: {{ $task->rejection_reason }}
                    </div>
                    @endif
                </div>

                <!-- Action Buttons -->
                <div class="flex-shrink-0 d-flex gap-1">
                    @if($task->status === 'pending')
                    <form action="{{ route('tasks.start', $task) }}" method="POST">
                        @csrf @method('PATCH')
                        <button class="btn btn-success btn-sm">
                            <i class="bi bi-play-fill me-1"></i>Start Task
                        </button>
                    </form>
                    @elseif($task->status === 'in_progress')
                    <form action="{{ route('tasks.complete', $task) }}" method="POST">
                        @csrf @method('PATCH')
                        <button class="btn btn-warning btn-sm">
                            <i class="bi bi-stop-fill me-1"></i>Mark Complete
                        </button>
                    </form>
                    @elseif($task->status === 'rejected')
                    <form action="{{ route('tasks.start', $task) }}" method="POST">
                        @csrf @method('PATCH')
                        <button class="btn btn-primary btn-sm">
                            <i class="bi bi-arrow-repeat me-1"></i>Re-start
                        </button>
                    </form>
                    @endif
                    <a href="{{ route('tasks.show', $task) }}" class="btn btn-outline-secondary btn-sm">
                        <i class="bi bi-eye"></i>
                    </a>
                </div>
            </div>
        </div>
        @empty
        <div class="text-center py-5 text-muted">
            <i class="bi bi-clipboard display-5 d-block mb-3 opacity-50"></i>
            <h6>No tasks assigned yet.</h6>
            <a href="{{ route('tasks.create') }}" class="btn btn-primary btn-sm mt-2">
                <i class="bi bi-plus-circle me-1"></i>Create Your First Task
            </a>
        </div>
        @endforelse
    </div>
</div>
@endsection
