@extends('layouts.app')
@section('title', 'Marketing Dashboard')
@section('page-title', 'Marketing Dashboard')

@section('content')
<!-- Stats -->
<div class="row g-3 mb-4">
    <div class="col-md-3">
        <div class="stat-card bg-white">
            <div class="d-flex align-items-center justify-content-between">
                <div>
                    <div class="text-muted small mb-1">My Total Tasks</div>
                    <div class="fw-bold fs-3">{{ $stats['my_tasks'] }}</div>
                </div>
                <div class="stat-icon" style="background:#e0e7ff;color:#6366f1;">
                    <i class="bi bi-list-task"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card bg-white">
            <div class="d-flex align-items-center justify-content-between">
                <div>
                    <div class="text-muted small mb-1">Pending Approval</div>
                    <div class="fw-bold fs-3 text-warning">{{ $stats['pending_review'] }}</div>
                </div>
                <div class="stat-icon" style="background:#fef9c3;color:#ca8a04;">
                    <i class="bi bi-hourglass-split"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card bg-white">
            <div class="d-flex align-items-center justify-content-between">
                <div>
                    <div class="text-muted small mb-1">Approved Today</div>
                    <div class="fw-bold fs-3 text-success">{{ $stats['approved_today'] }}</div>
                </div>
                <div class="stat-icon" style="background:#dcfce7;color:#16a34a;">
                    <i class="bi bi-check-circle"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card bg-white">
            <div class="d-flex align-items-center justify-content-between">
                <div>
                    <div class="text-muted small mb-1">My Pending</div>
                    <div class="fw-bold fs-3 text-secondary">{{ $stats['my_pending'] }}</div>
                </div>
                <div class="stat-icon" style="background:#f1f5f9;color:#64748b;">
                    <i class="bi bi-clock"></i>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row g-3">
    <!-- Pending Approvals -->
    <div class="col-md-7">
        <div class="card">
            <div class="card-header py-3 d-flex justify-content-between align-items-center">
                <span><i class="bi bi-clipboard-check me-2 text-warning"></i>Tasks Pending Your Approval</span>
                <span class="badge bg-warning text-dark">{{ count($pendingApprovals) }}</span>
            </div>
            <div class="card-body p-0">
                @forelse($pendingApprovals as $task)
                <div class="d-flex align-items-start gap-3 p-3 border-bottom">
                    <div class="stat-icon flex-shrink-0" style="background:#fef9c3;color:#ca8a04;width:40px;height:40px;font-size:1rem;">
                        <i class="bi bi-file-earmark-text"></i>
                    </div>
                    <div class="flex-grow-1">
                        <div class="fw-semibold small">{{ $task->title }}</div>
                        <div class="text-muted" style="font-size:0.75rem;">
                            Assigned to: <strong>{{ $task->assignedUser->name }}</strong>
                            &bull; Completed: {{ $task->actual_end ? $task->actual_end->format('d M Y h:i A') : 'N/A' }}
                        </div>
                        <span class="badge bg-{{ $task->priorityBadge() }} mt-1">{{ $task->priority }}</span>
                    </div>
                    <div class="d-flex gap-1 flex-shrink-0">
                        <a href="{{ route('tasks.show', $task) }}" class="btn btn-sm btn-outline-primary">
                            <i class="bi bi-eye"></i>
                        </a>
                    </div>
                </div>
                @empty
                <div class="text-center py-5 text-muted">
                    <i class="bi bi-check-all display-6 d-block mb-2"></i>
                    No tasks pending approval!
                </div>
                @endforelse
            </div>
            @if(count($pendingApprovals) > 0)
            <div class="card-footer text-center">
                <a href="{{ route('approvals.index') }}" class="btn btn-warning btn-sm">
                    <i class="bi bi-arrow-right me-1"></i>Review All Pending Tasks
                </a>
            </div>
            @endif
        </div>
    </div>

    <!-- My Tasks -->
    <div class="col-md-5">
        <div class="card">
            <div class="card-header py-3 d-flex justify-content-between align-items-center">
                <span><i class="bi bi-person-check me-2 text-primary"></i>My Tasks</span>
                <a href="{{ route('tasks.create') }}" class="btn btn-sm btn-primary">
                    <i class="bi bi-plus"></i> Add
                </a>
            </div>
            <div class="card-body p-0">
                @forelse($myTasks as $task)
                <div class="d-flex align-items-center gap-3 p-3 border-bottom">
                    <div class="flex-grow-1">
                        <div class="fw-semibold small">{{ Str::limit($task->title, 30) }}</div>
                        <small class="text-muted">Due: {{ $task->planned_end->format('d M Y') }}</small>
                    </div>
                    <div class="d-flex flex-column align-items-end gap-1">
                        <span class="badge status-{{ $task->status }} small">
                            {{ str_replace('_', ' ', ucfirst($task->status)) }}
                        </span>
                        @if($task->status === 'pending')
                        <form action="{{ route('tasks.start', $task) }}" method="POST">
                            @csrf @method('PATCH')
                            <button class="btn btn-success btn-sm py-0 px-2" style="font-size:0.7rem;">
                                <i class="bi bi-play-fill"></i> Start
                            </button>
                        </form>
                        @elseif($task->status === 'in_progress')
                        <form action="{{ route('tasks.complete', $task) }}" method="POST">
                            @csrf @method('PATCH')
                            <button class="btn btn-warning btn-sm py-0 px-2" style="font-size:0.7rem;">
                                <i class="bi bi-stop-fill"></i> Complete
                            </button>
                        </form>
                        @elseif($task->status === 'rejected')
                        <form action="{{ route('tasks.start', $task) }}" method="POST">
                            @csrf @method('PATCH')
                            <button class="btn btn-primary btn-sm py-0 px-2" style="font-size:0.7rem;">
                                <i class="bi bi-arrow-repeat"></i> Re-start
                            </button>
                        </form>
                        @endif
                    </div>
                </div>
                @empty
                <div class="text-center py-4 text-muted small">No tasks assigned to you.</div>
                @endforelse
            </div>
        </div>
    </div>
</div>
@endsection
