<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', 'Task Management System')</title>

    <!-- Bootstrap 5 -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css" rel="stylesheet">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <style>
        * { font-family: 'Inter', sans-serif; }

        /* Sidebar */
        .sidebar {
            width: 260px;
            min-height: 100vh;
            background: linear-gradient(180deg, #1a1a2e 0%, #16213e 50%, #0f3460 100%);
            position: fixed;
            left: 0;
            top: 0;
            z-index: 1000;
            transition: all 0.3s;
        }
        .sidebar .brand {
            padding: 20px;
            border-bottom: 1px solid rgba(255,255,255,0.1);
        }
        .sidebar .brand h5 {
            color: #fff;
            margin: 0;
            font-weight: 700;
            font-size: 1rem;
        }
        .sidebar .brand small {
            color: rgba(255,255,255,0.5);
            font-size: 0.75rem;
        }
        .sidebar .nav-link {
            color: rgba(255,255,255,0.7);
            padding: 10px 20px;
            border-radius: 8px;
            margin: 2px 10px;
            font-size: 0.875rem;
            transition: all 0.2s;
        }
        .sidebar .nav-link:hover,
        .sidebar .nav-link.active {
            color: #fff;
            background: rgba(255,255,255,0.15);
        }
        .sidebar .nav-link i { width: 20px; }

        .sidebar .section-title {
            color: rgba(255,255,255,0.35);
            font-size: 0.65rem;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 1px;
            padding: 15px 20px 5px;
        }

        /* Main Content */
        .main-content {
            margin-left: 260px;
            min-height: 100vh;
            background: #f8f9fa;
        }
        .topbar {
            background: #fff;
            padding: 12px 25px;
            border-bottom: 1px solid #e9ecef;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .page-content { padding: 25px; }

        /* Role Badge */
        .role-badge {
            font-size: 0.65rem;
            padding: 2px 8px;
            border-radius: 20px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        .role-super_admin { background: #dc3545; color: #fff; }
        .role-admin        { background: #0d6efd; color: #fff; }
        .role-marketing    { background: #fd7e14; color: #fff; }
        .role-designer     { background: #6f42c1; color: #fff; }
        .role-developer    { background: #198754; color: #fff; }

        /* Stat Cards */
        .stat-card {
            border: none;
            border-radius: 12px;
            padding: 20px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        }
        .stat-card .stat-icon {
            width: 48px;
            height: 48px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.3rem;
        }

        /* Task Status Colors */
        .status-pending      { background: #6c757d; color: #fff; }
        .status-in_progress  { background: #0d6efd; color: #fff; }
        .status-under_review { background: #ffc107; color: #000; }
        .status-approved     { background: #198754; color: #fff; }
        .status-rejected     { background: #dc3545; color: #fff; }
        .status-completed    { background: #212529; color: #fff; }

        /* Tables */
        .table th { font-size: 0.8rem; text-transform: uppercase; letter-spacing: 0.5px; color: #6c757d; border-top: none; }
        .table td { vertical-align: middle; font-size: 0.875rem; }

        /* Cards */
        .card { border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.05); border-radius: 12px; }
        .card-header { background: #fff; border-bottom: 1px solid #f0f0f0; font-weight: 600; }

        /* Alert */
        .alert { border: none; border-radius: 10px; }

        /* User Avatar */
        .avatar {
            width: 36px;
            height: 36px;
            border-radius: 50%;
            background: #0d6efd;
            color: #fff;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            font-weight: 600;
            font-size: 0.8rem;
        }

        /* Gantt-like progress bar */
        .task-progress-bar { height: 20px; border-radius: 4px; }

        @media (max-width: 768px) {
            .sidebar { transform: translateX(-100%); }
            .sidebar.show { transform: translateX(0); }
            .main-content { margin-left: 0; }
        }
    </style>

    @yield('styles')
</head>
<body>

<!-- Sidebar -->
<div class="sidebar" id="sidebar">
    <div class="brand d-flex align-items-center gap-2">
        <div style="width:36px;height:36px;background:linear-gradient(135deg,#6366f1,#8b5cf6);border-radius:10px;display:flex;align-items:center;justify-content:center;">
            <i class="bi bi-kanban-fill text-white"></i>
        </div>
        <div>
            <h5>TaskFlow</h5>
            <small>Task Management</small>
        </div>
    </div>

    <div class="mt-3">
        <div class="section-title">Main</div>
        <a href="{{ route('dashboard') }}" class="nav-link {{ request()->routeIs('dashboard') ? 'active' : '' }}">
            <i class="bi bi-speedometer2 me-2"></i> Dashboard
        </a>

        @if(auth()->user()->canManageTasks() || auth()->user()->isMarketing())
        <a href="{{ route('tasks.index') }}" class="nav-link {{ request()->routeIs('tasks.*') ? 'active' : '' }}">
            <i class="bi bi-list-task me-2"></i> All Tasks
        </a>
        @else
        <a href="{{ route('tasks.index') }}" class="nav-link {{ request()->routeIs('tasks.*') ? 'active' : '' }}">
            <i class="bi bi-list-task me-2"></i> My Tasks
        </a>
        @endif

        <a href="{{ route('tasks.create') }}" class="nav-link {{ request()->routeIs('tasks.create') ? 'active' : '' }}">
            <i class="bi bi-plus-circle me-2"></i> Create Task
        </a>

        <a href="{{ route('tasks.history') }}" class="nav-link {{ request()->routeIs('tasks.history') ? 'active' : '' }}">
            <i class="bi bi-clock-history me-2"></i> Task History
        </a>

        @if(auth()->user()->canApprove())
        <div class="section-title">Approvals</div>
        <a href="{{ route('approvals.index') }}" class="nav-link {{ request()->routeIs('approvals.*') ? 'active' : '' }}">
            <i class="bi bi-check-circle me-2"></i> Pending Approvals
            @php $pendingCount = \App\Models\Task::where('status','under_review')->count(); @endphp
            @if($pendingCount > 0)
            <span class="badge bg-warning text-dark ms-1">{{ $pendingCount }}</span>
            @endif
        </a>
        <a href="{{ route('approvals.history') }}" class="nav-link">
            <i class="bi bi-archive me-2"></i> Approval History
        </a>
        @endif

        @if(auth()->user()->canManageTasks())
        <div class="section-title">Administration</div>
        <a href="{{ route('users.index') }}" class="nav-link {{ request()->routeIs('users.*') ? 'active' : '' }}">
            <i class="bi bi-people me-2"></i> Team Members
        </a>
        @if(auth()->user()->isSuperAdmin())
        <a href="{{ route('users.create') }}" class="nav-link">
            <i class="bi bi-person-plus me-2"></i> Add User
        </a>
        @endif
        @endif
    </div>

    <!-- User info at bottom -->
    <div style="position:absolute;bottom:0;left:0;right:0;padding:15px 20px;border-top:1px solid rgba(255,255,255,0.1);">
        <a href="{{ route('profile.show') }}" class="text-decoration-none">
            <div class="d-flex align-items-center gap-2">
                <div class="avatar">{{ strtoupper(substr(auth()->user()->name, 0, 1)) }}</div>
                <div>
                    <div style="color:#fff;font-size:0.8rem;font-weight:600;">{{ auth()->user()->name }}</div>
                    <span class="role-badge role-{{ auth()->user()->role }}">{{ str_replace('_', ' ', auth()->user()->role) }}</span>
                </div>
                <i class="bi bi-pencil-square ms-auto text-white-50" style="font-size:0.75rem;" title="Edit Profile"></i>
            </div>
        </a>
    </div>
</div>

<!-- Main Content -->
<div class="main-content">
    <!-- Topbar -->
    <div class="topbar">
        <div class="d-flex align-items-center gap-3">
            <button class="btn btn-sm btn-outline-secondary d-md-none" onclick="document.getElementById('sidebar').classList.toggle('show')">
                <i class="bi bi-list"></i>
            </button>
            <h6 class="mb-0 fw-semibold text-muted">@yield('page-title', 'Dashboard')</h6>
        </div>
        <div class="d-flex align-items-center gap-3">
            <span class="text-muted small d-none d-md-block">{{ now()->format('d M Y') }}</span>

            {{-- Notification Bell --}}
            @php
                $unreadCount = \App\Models\Notification::where('user_id', auth()->id())->whereNull('read_at')->count();
                $recentNotifs = \App\Models\Notification::where('user_id', auth()->id())->latest()->take(6)->get();
            @endphp
            <div class="dropdown">
                <button class="btn btn-sm btn-outline-secondary position-relative" data-bs-toggle="dropdown" aria-expanded="false" title="Notifications">
                    <i class="bi bi-bell"></i>
                    @if($unreadCount > 0)
                    <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger"
                          style="font-size:0.55rem;padding:3px 5px;">
                        {{ $unreadCount > 9 ? '9+' : $unreadCount }}
                    </span>
                    @endif
                </button>
                <div class="dropdown-menu dropdown-menu-end shadow border-0 p-0" style="width:330px;max-height:430px;overflow-y:auto;border-radius:12px;">
                    {{-- Header --}}
                    <div class="d-flex justify-content-between align-items-center px-3 py-2 border-bottom bg-light" style="border-radius:12px 12px 0 0;">
                        <span class="fw-semibold" style="font-size:0.85rem;">
                            <i class="bi bi-bell me-1"></i> Notifications
                            @if($unreadCount > 0)
                            <span class="badge bg-danger ms-1" style="font-size:0.65rem;">{{ $unreadCount }}</span>
                            @endif
                        </span>
                        @if($unreadCount > 0)
                        <form action="{{ route('notifications.readAll') }}" method="POST" class="d-inline m-0">
                            @csrf
                            <button type="submit" class="btn btn-link btn-sm p-0 text-muted" style="font-size:0.75rem;">Mark all read</button>
                        </form>
                        @endif
                    </div>
                    {{-- List --}}
                    @forelse($recentNotifs as $notif)
                    <div class="{{ $notif->isRead() ? '' : 'bg-primary bg-opacity-10' }} border-bottom">
                        <form action="{{ route('notifications.read', $notif) }}" method="POST" class="m-0">
                            @csrf
                            <button type="submit" class="btn btn-link p-0 w-100 text-start" style="text-decoration:none;">
                                <div class="d-flex gap-2 px-3 py-2">
                                    <div class="flex-shrink-0 mt-1">
                                        <i class="bi {{ $notif->iconClass() }}" style="font-size:1rem;"></i>
                                    </div>
                                    <div class="overflow-hidden">
                                        <div class="fw-semibold text-dark" style="font-size:0.8rem;white-space:normal;">{{ $notif->title }}</div>
                                        <div class="text-muted" style="font-size:0.75rem;white-space:normal;line-height:1.3;">{{ Str::limit($notif->message, 70) }}</div>
                                        <div class="text-muted mt-1" style="font-size:0.7rem;">{{ $notif->created_at->diffForHumans() }}</div>
                                    </div>
                                </div>
                            </button>
                        </form>
                    </div>
                    @empty
                    <div class="text-center text-muted py-4" style="font-size:0.85rem;">
                        <i class="bi bi-bell-slash d-block mb-1" style="font-size:1.5rem;"></i>
                        No notifications yet
                    </div>
                    @endforelse
                    {{-- Footer --}}
                    <div class="text-center py-2 border-top bg-light" style="border-radius:0 0 12px 12px;">
                        <a href="{{ route('notifications.index') }}" class="text-primary" style="font-size:0.8rem;">
                            View all notifications
                        </a>
                    </div>
                </div>
            </div>

            <a href="{{ route('logout') }}" class="btn btn-sm btn-outline-danger"
               onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                <i class="bi bi-box-arrow-right me-1"></i> Logout
            </a>
            <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display:none;">
                @csrf
            </form>
        </div>
    </div>

    <!-- Page Content -->
    <div class="page-content">
        <!-- Alerts -->
        @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="bi bi-check-circle me-2"></i> {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
        @endif
        @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="bi bi-exclamation-circle me-2"></i> {{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
        @endif

        @yield('content')
    </div>
</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
@yield('scripts')
</body>
</html>
