@extends('layouts.app')
@section('title', 'Create Task')
@section('page-title', 'Create Task')

@section('content')
<div class="row justify-content-center">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header py-3">
                <i class="bi bi-plus-circle me-2 text-primary"></i>Create New Task
            </div>
            <div class="card-body">
                <form action="{{ route('tasks.store') }}" method="POST" enctype="multipart/form-data">
                    @csrf

                    <div class="mb-3">
                        <label class="form-label fw-semibold">Task Title <span class="text-danger">*</span></label>
                        <input type="text" name="title" class="form-control @error('title') is-invalid @enderror"
                               value="{{ old('title') }}" placeholder="Enter task title" required>
                        @error('title')<div class="invalid-feedback">{{ $message }}</div>@enderror
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-semibold">Description</label>
                        <textarea name="description" class="form-control @error('description') is-invalid @enderror"
                                  rows="4" placeholder="Describe the task...">{{ old('description') }}</textarea>
                        @error('description')<div class="invalid-feedback">{{ $message }}</div>@enderror
                    </div>

                    <div class="row g-3">
                        <div class="col-md-6">
                            <label class="form-label fw-semibold">Assign To <span class="text-danger">*</span></label>
                            @if(auth()->user()->canAssignTasks())
                            <select name="assigned_to" class="form-select @error('assigned_to') is-invalid @enderror" required>
                                <option value="">Select team member...</option>
                                @foreach($users as $u)
                                <option value="{{ $u->id }}" {{ old('assigned_to') == $u->id ? 'selected' : '' }}>
                                    {{ $u->name }} ({{ str_replace('_', ' ', $u->role) }})
                                </option>
                                @endforeach
                            </select>
                            @else
                            <input type="hidden" name="assigned_to" value="{{ auth()->id() }}">
                            <input type="text" class="form-control" value="{{ auth()->user()->name }} (Myself)" readonly>
                            @endif
                            @error('assigned_to')<div class="invalid-feedback">{{ $message }}</div>@enderror
                        </div>

                        <div class="col-md-6">
                            <label class="form-label fw-semibold">Priority <span class="text-danger">*</span></label>
                            <select name="priority" class="form-select @error('priority') is-invalid @enderror" required>
                                <option value="">Select priority...</option>
                                <option value="high" {{ old('priority') === 'high' ? 'selected' : '' }}>🔴 High</option>
                                <option value="medium" {{ old('priority') === 'medium' ? 'selected' : '' }}>🟡 Medium</option>
                                <option value="low" {{ old('priority') === 'low' ? 'selected' : '' }}>🟢 Low</option>
                            </select>
                            @error('priority')<div class="invalid-feedback">{{ $message }}</div>@enderror
                        </div>

                        <div class="col-md-6">
                            <label class="form-label fw-semibold">Planned Start Date <span class="text-danger">*</span></label>
                            <input type="date" name="planned_start" class="form-control @error('planned_start') is-invalid @enderror"
                                   value="{{ old('planned_start') }}" required>
                            @error('planned_start')<div class="invalid-feedback">{{ $message }}</div>@enderror
                        </div>

                        <div class="col-md-6">
                            <label class="form-label fw-semibold">Planned End Date <span class="text-danger">*</span></label>
                            <input type="date" name="planned_end" class="form-control @error('planned_end') is-invalid @enderror"
                                   value="{{ old('planned_end') }}" required>
                            @error('planned_end')<div class="invalid-feedback">{{ $message }}</div>@enderror
                        </div>
                    </div>

                    <div class="mb-3 mt-3">
                        <label class="form-label fw-semibold">Attachment <span class="text-muted small">(optional, max 5MB)</span></label>
                        <input type="file" name="attachment" class="form-control @error('attachment') is-invalid @enderror">
                        @error('attachment')<div class="invalid-feedback">{{ $message }}</div>@enderror
                    </div>

                    <div class="d-flex justify-content-end gap-2 mt-4">
                        <a href="{{ route('tasks.index') }}" class="btn btn-secondary">
                            <i class="bi bi-arrow-left me-1"></i> Cancel
                        </a>
                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-check-circle me-1"></i> Create Task
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
