@extends('layouts.app')
@section('title', 'Edit Task')
@section('page-title', 'Edit Task')

@section('content')
<div class="row justify-content-center">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header py-3">
                <i class="bi bi-pencil me-2 text-warning"></i>Edit Task: {{ $task->title }}
            </div>
            <div class="card-body">
                <form action="{{ route('tasks.update', $task) }}" method="POST" enctype="multipart/form-data">
                    @csrf @method('PUT')

                    <div class="mb-3">
                        <label class="form-label fw-semibold">Task Title <span class="text-danger">*</span></label>
                        <input type="text" name="title" class="form-control @error('title') is-invalid @enderror"
                               value="{{ old('title', $task->title) }}" required>
                        @error('title')<div class="invalid-feedback">{{ $message }}</div>@enderror
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-semibold">Description</label>
                        <textarea name="description" class="form-control" rows="4">{{ old('description', $task->description) }}</textarea>
                    </div>

                    <div class="row g-3">
                        <div class="col-md-6">
                            <label class="form-label fw-semibold">Assign To <span class="text-danger">*</span></label>
                            @if(auth()->user()->canAssignTasks())
                            <select name="assigned_to" class="form-select" required>
                                @foreach($users as $u)
                                <option value="{{ $u->id }}" {{ old('assigned_to', $task->assigned_to) == $u->id ? 'selected' : '' }}>
                                    {{ $u->name }} ({{ str_replace('_', ' ', $u->role) }})
                                </option>
                                @endforeach
                            </select>
                            @else
                            <input type="hidden" name="assigned_to" value="{{ auth()->id() }}">
                            <input type="text" class="form-control" value="{{ auth()->user()->name }}" readonly>
                            @endif
                        </div>
                        <div class="col-md-6">
                            <label class="form-label fw-semibold">Priority <span class="text-danger">*</span></label>
                            <select name="priority" class="form-select" required>
                                <option value="high"   {{ old('priority', $task->priority) === 'high'   ? 'selected' : '' }}>🔴 High</option>
                                <option value="medium" {{ old('priority', $task->priority) === 'medium' ? 'selected' : '' }}>🟡 Medium</option>
                                <option value="low"    {{ old('priority', $task->priority) === 'low'    ? 'selected' : '' }}>🟢 Low</option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label fw-semibold">Planned Start Date <span class="text-danger">*</span></label>
                            <input type="date" name="planned_start" class="form-control"
                                   value="{{ old('planned_start', $task->planned_start->format('Y-m-d')) }}" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label fw-semibold">Planned End Date <span class="text-danger">*</span></label>
                            <input type="date" name="planned_end" class="form-control"
                                   value="{{ old('planned_end', $task->planned_end->format('Y-m-d')) }}" required>
                        </div>
                    </div>

                    @if($task->attachment)
                    <div class="mt-3">
                        <label class="form-label fw-semibold">Current Attachment</label>
                        <div>
                            <a href="{{ Storage::url($task->attachment) }}" target="_blank" class="btn btn-sm btn-outline-info">
                                <i class="bi bi-paperclip me-1"></i>View Current File
                            </a>
                        </div>
                    </div>
                    @endif

                    <div class="mb-3 mt-3">
                        <label class="form-label fw-semibold">New Attachment <span class="text-muted small">(optional, replaces current)</span></label>
                        <input type="file" name="attachment" class="form-control">
                    </div>

                    <div class="d-flex justify-content-end gap-2 mt-4">
                        <a href="{{ route('tasks.show', $task) }}" class="btn btn-secondary">
                            <i class="bi bi-arrow-left me-1"></i> Cancel
                        </a>
                        <button type="submit" class="btn btn-warning">
                            <i class="bi bi-save me-1"></i> Update Task
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
