@extends('layouts.app')
@section('title', 'Task History')
@section('page-title', 'Task History')

@section('content')
<div class="card">
    <div class="card-header py-3 d-flex justify-content-between align-items-center">
        <span><i class="bi bi-clock-history me-2 text-info"></i>Task Activity History</span>
    </div>

    @if(auth()->user()->canManageTasks())
    <div class="card-body border-bottom py-3">
        <form method="GET" class="row g-2 align-items-end">
            <div class="col-md-4">
                <select name="user_id" class="form-select form-select-sm">
                    <option value="">All Team Members</option>
                    @foreach($users as $u)
                    <option value="{{ $u->id }}" {{ request('user_id') == $u->id ? 'selected' : '' }}>
                        {{ $u->name }}
                    </option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-2">
                <button type="submit" class="btn btn-secondary btn-sm">
                    <i class="bi bi-funnel me-1"></i>Filter
                </button>
            </div>
        </form>
    </div>
    @endif

    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table mb-0">
                <thead>
                    <tr>
                        <th class="ps-3">Task</th>
                        <th>Action By</th>
                        <th>Action</th>
                        <th>Note</th>
                        <th>Date & Time</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($logs as $log)
                    <tr>
                        <td class="ps-3">
                            <a href="{{ route('tasks.show', $log->task) }}" class="text-decoration-none fw-medium small">
                                {{ Str::limit($log->task->title, 35) }}
                            </a>
                        </td>
                        <td>
                            <div class="d-flex align-items-center gap-1">
                                <div class="avatar" style="width:26px;height:26px;font-size:0.65rem;">
                                    {{ strtoupper(substr($log->user->name, 0, 1)) }}
                                </div>
                                <span class="small">{{ $log->user->name }}</span>
                            </div>
                        </td>
                        <td>
                            <span class="badge bg-{{ $log->actionBadge() }}">{{ $log->actionLabel() }}</span>
                        </td>
                        <td><small class="text-muted">{{ Str::limit($log->note, 50) ?? '—' }}</small></td>
                        <td><small class="text-muted">{{ $log->created_at->format('d M Y, h:i A') }}</small></td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="5" class="text-center py-5 text-muted">
                            <i class="bi bi-inbox display-6 d-block mb-2 opacity-50"></i>
                            No activity found.
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    @if($logs->hasPages())
    <div class="card-footer">
        {{ $logs->links() }}
    </div>
    @endif
</div>
@endsection
