@extends('layouts.app')
@section('title', 'Tasks')
@section('page-title', 'Tasks')

@section('content')
<div class="card">
    <div class="card-header py-3">
        <div class="d-flex justify-content-between align-items-center flex-wrap gap-2">
            <span><i class="bi bi-list-task me-2 text-primary"></i>
                {{ auth()->user()->canManageTasks() ? 'All Tasks' : 'My Tasks' }}
            </span>
            <a href="{{ route('tasks.create') }}" class="btn btn-primary btn-sm">
                <i class="bi bi-plus-circle me-1"></i> Create Task
            </a>
        </div>
    </div>

    <!-- Filters -->
    <div class="card-body border-bottom py-3">
        <form method="GET" class="row g-2 align-items-end">
            <div class="col-md-4">
                <input type="text" name="search" class="form-control form-control-sm"
                       placeholder="Search tasks..." value="{{ request('search') }}">
            </div>
            <div class="col-md-2">
                <select name="status" class="form-select form-select-sm">
                    <option value="">All Status</option>
                    <option value="pending" {{ request('status') === 'pending' ? 'selected' : '' }}>Pending</option>
                    <option value="in_progress" {{ request('status') === 'in_progress' ? 'selected' : '' }}>In Progress</option>
                    <option value="under_review" {{ request('status') === 'under_review' ? 'selected' : '' }}>Under Review</option>
                    <option value="approved" {{ request('status') === 'approved' ? 'selected' : '' }}>Approved</option>
                    <option value="rejected" {{ request('status') === 'rejected' ? 'selected' : '' }}>Rejected</option>
                </select>
            </div>
            <div class="col-md-2">
                <select name="priority" class="form-select form-select-sm">
                    <option value="">All Priority</option>
                    <option value="high" {{ request('priority') === 'high' ? 'selected' : '' }}>High</option>
                    <option value="medium" {{ request('priority') === 'medium' ? 'selected' : '' }}>Medium</option>
                    <option value="low" {{ request('priority') === 'low' ? 'selected' : '' }}>Low</option>
                </select>
            </div>
            @if(auth()->user()->canManageTasks())
            <div class="col-md-2">
                <select name="assigned_to" class="form-select form-select-sm">
                    <option value="">All Members</option>
                    @foreach($users as $u)
                    <option value="{{ $u->id }}" {{ request('assigned_to') == $u->id ? 'selected' : '' }}>
                        {{ $u->name }}
                    </option>
                    @endforeach
                </select>
            </div>
            @endif
            <div class="col-md-2">
                <button type="submit" class="btn btn-secondary btn-sm w-100">
                    <i class="bi bi-funnel me-1"></i> Filter
                </button>
            </div>
        </form>
    </div>

    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table mb-0">
                <thead>
                    <tr>
                        <th class="ps-3">#</th>
                        <th>Task Title</th>
                        @if(auth()->user()->canManageTasks() || auth()->user()->isMarketing())
                        <th>Assigned To</th>
                        @endif
                        <th>Priority</th>
                        <th>Planned Start</th>
                        <th>Planned End</th>
                        <th>Actual Start</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($tasks as $task)
                    <tr class="{{ $task->isOverdue() ? 'table-danger' : ($task->status === 'rejected' ? 'table-warning' : '') }}">
                        <td class="ps-3 text-muted small">{{ $task->id }}</td>
                        <td>
                            <a href="{{ route('tasks.show', $task) }}" class="fw-medium text-decoration-none">
                                {{ Str::limit($task->title, 40) }}
                            </a>
                            @if($task->isOverdue())
                            <span class="badge bg-danger ms-1" style="font-size:0.6rem;">OVERDUE</span>
                            @endif
                        </td>
                        @if(auth()->user()->canManageTasks() || auth()->user()->isMarketing())
                        <td>
                            <div class="d-flex align-items-center gap-1">
                                <div class="avatar" style="width:26px;height:26px;font-size:0.65rem;">
                                    {{ strtoupper(substr($task->assignedUser->name, 0, 1)) }}
                                </div>
                                <span class="small">{{ $task->assignedUser->name }}</span>
                            </div>
                        </td>
                        @endif
                        <td>
                            <span class="badge bg-{{ $task->priorityBadge() }}">{{ $task->priority }}</span>
                        </td>
                        <td><small>{{ $task->planned_start->format('d M Y') }}</small></td>
                        <td>
                            <small class="{{ $task->isOverdue() ? 'text-danger fw-bold' : '' }}">
                                {{ $task->planned_end->format('d M Y') }}
                            </small>
                        </td>
                        <td>
                            <small class="text-muted">
                                {{ $task->actual_start ? $task->actual_start->format('d M Y') : '—' }}
                            </small>
                        </td>
                        <td>
                            <span class="badge status-{{ $task->status }}">
                                {{ str_replace('_', ' ', ucfirst($task->status)) }}
                            </span>
                        </td>
                        <td>
                            <div class="d-flex gap-1 flex-wrap">
                                <a href="{{ route('tasks.show', $task) }}" class="btn btn-sm btn-outline-primary" title="View">
                                    <i class="bi bi-eye"></i>
                                </a>

                                {{-- Quick action buttons based on status --}}
                                @if($task->assigned_to === auth()->id() || auth()->user()->canManageTasks())
                                    @if($task->status === 'pending')
                                    <form action="{{ route('tasks.start', $task) }}" method="POST">
                                        @csrf @method('PATCH')
                                        <button class="btn btn-sm btn-success" title="Start Task">
                                            <i class="bi bi-play-fill"></i>
                                        </button>
                                    </form>
                                    @elseif($task->status === 'in_progress')
                                    <form action="{{ route('tasks.complete', $task) }}" method="POST">
                                        @csrf @method('PATCH')
                                        <button class="btn btn-sm btn-warning" title="Mark Complete">
                                            <i class="bi bi-stop-fill"></i>
                                        </button>
                                    </form>
                                    @elseif($task->status === 'rejected')
                                    <form action="{{ route('tasks.start', $task) }}" method="POST">
                                        @csrf @method('PATCH')
                                        <button class="btn btn-sm btn-primary" title="Re-start Task">
                                            <i class="bi bi-arrow-repeat"></i>
                                        </button>
                                    </form>
                                    @endif
                                @endif

                                @if(!in_array($task->status, ['approved', 'completed']))
                                <a href="{{ route('tasks.edit', $task) }}" class="btn btn-sm btn-outline-secondary" title="Edit">
                                    <i class="bi bi-pencil"></i>
                                </a>
                                @endif
                                @if(auth()->user()->canManageTasks())
                                <form action="{{ route('tasks.destroy', $task) }}" method="POST"
                                      onsubmit="return confirm('Are you sure you want to delete this task?')">
                                    @csrf @method('DELETE')
                                    <button class="btn btn-sm btn-outline-danger" title="Delete">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </form>
                                @endif
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="9" class="text-center text-muted py-5">
                            <i class="bi bi-inbox display-6 d-block mb-2 opacity-50"></i>
                            No tasks found.
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    @if($tasks->hasPages())
    <div class="card-footer">
        {{ $tasks->links() }}
    </div>
    @endif
</div>
@endsection
