@extends('layouts.app')
@section('title', 'Task Details')
@section('page-title', 'Task Details')

@section('content')
<div class="row g-3">
    <!-- Main Task Info -->
    <div class="col-md-8">
        <div class="card mb-3">
            <div class="card-header py-3 d-flex justify-content-between align-items-center">
                <span><i class="bi bi-file-earmark-text me-2"></i>Task Information</span>
                <div class="d-flex gap-2">
                    <span class="badge status-{{ $task->status }} fs-6">
                        {{ str_replace('_', ' ', ucfirst($task->status)) }}
                    </span>
                    <span class="badge bg-{{ $task->priorityBadge() }}">{{ ucfirst($task->priority) }} Priority</span>
                </div>
            </div>
            <div class="card-body">

                {{-- Parent task reference (this is a marketing task) --}}
                @if($task->parent_task_id && $task->parentTask)
                <div class="alert alert-info py-2 mb-3 d-flex align-items-center gap-2">
                    <i class="bi bi-link-45deg fs-5"></i>
                    <div>
                        <strong>Marketing Processing Task</strong> — originated from:
                        <a href="{{ route('tasks.show', $task->parentTask) }}" class="fw-semibold ms-1">
                            {{ $task->parentTask->title }}
                        </a>
                        <span class="badge bg-success ms-1">Approved</span>
                    </div>
                </div>
                @endif

                {{-- Child marketing task reference (original task that spawned a marketing task) --}}
                @if($task->marketingTask)
                <div class="alert alert-success py-2 mb-3 d-flex align-items-center gap-2">
                    <i class="bi bi-arrow-right-circle fs-5"></i>
                    <div>
                        <strong>Marketing task created:</strong>
                        <a href="{{ route('tasks.show', $task->marketingTask) }}" class="fw-semibold ms-1">
                            {{ $task->marketingTask->title }}
                        </a>
                        <span class="badge status-{{ $task->marketingTask->status }} ms-1">
                            {{ str_replace('_', ' ', ucfirst($task->marketingTask->status)) }}
                        </span>
                    </div>
                </div>
                @endif

                <h5 class="fw-bold mb-3">{{ $task->title }}</h5>

                @if($task->description)
                <p class="text-muted">{{ $task->description }}</p>
                <hr>
                @endif

                <div class="row g-3">
                    <div class="col-sm-6">
                        <div class="p-3 bg-light rounded">
                            <div class="text-muted small mb-1">Assigned To</div>
                            <div class="d-flex align-items-center gap-2">
                                <div class="avatar">{{ strtoupper(substr($task->assignedUser->name, 0, 1)) }}</div>
                                <div>
                                    <div class="fw-semibold">{{ $task->assignedUser->name }}</div>
                                    <span class="role-badge role-{{ $task->assignedUser->role }}">
                                        {{ str_replace('_', ' ', $task->assignedUser->role) }}
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="p-3 bg-light rounded">
                            <div class="text-muted small mb-1">Created By</div>
                            <div class="d-flex align-items-center gap-2">
                                <div class="avatar" style="background:#6f42c1;">
                                    {{ strtoupper(substr($task->createdByUser->name, 0, 1)) }}
                                </div>
                                <div>
                                    <div class="fw-semibold">{{ $task->createdByUser->name }}</div>
                                    <small class="text-muted">{{ $task->created_at->format('d M Y') }}</small>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="text-muted small">Planned Start</div>
                        <div class="fw-semibold">{{ $task->planned_start->format('d M Y') }}</div>
                    </div>
                    <div class="col-sm-3">
                        <div class="text-muted small">Planned End</div>
                        <div class="fw-semibold {{ $task->isOverdue() ? 'text-danger' : '' }}">
                            {{ $task->planned_end->format('d M Y') }}
                            @if($task->isOverdue()) <span class="badge bg-danger ms-1">Overdue</span> @endif
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="text-muted small">Actual Start</div>
                        <div class="fw-semibold">
                            {{ $task->actual_start ? $task->actual_start->format('d M Y h:i A') : '—' }}
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="text-muted small">Actual End</div>
                        <div class="fw-semibold">
                            {{ $task->actual_end ? $task->actual_end->format('d M Y h:i A') : '—' }}
                        </div>
                    </div>
                </div>

                @if($task->attachment)
                <div class="mt-3">
                    <div class="text-muted small mb-1">Attachment</div>
                    <a href="{{ Storage::url($task->attachment) }}" target="_blank" class="btn btn-sm btn-outline-info">
                        <i class="bi bi-paperclip me-1"></i> View Attachment
                    </a>
                </div>
                @endif

                @if($task->status === 'rejected' && $task->rejection_reason)
                <div class="alert alert-danger mt-3">
                    <i class="bi bi-exclamation-triangle me-2"></i>
                    <strong>Rejection Reason:</strong> {{ $task->rejection_reason }}
                </div>
                @endif
            </div>

            <!-- Action Buttons -->
            <div class="card-footer d-flex gap-2 flex-wrap">
                @if($task->assigned_to === auth()->id() || auth()->user()->canManageTasks())
                    @if($task->status === 'pending')
                    <form action="{{ route('tasks.start', $task) }}" method="POST">
                        @csrf @method('PATCH')
                        <button class="btn btn-success">
                            <i class="bi bi-play-fill me-1"></i>Start Task
                        </button>
                    </form>
                    @elseif($task->status === 'in_progress')
                    <form action="{{ route('tasks.complete', $task) }}" method="POST">
                        @csrf @method('PATCH')
                        <button class="btn btn-warning">
                            <i class="bi bi-stop-fill me-1"></i>Mark Complete & Submit for Review
                        </button>
                    </form>
                    @elseif($task->status === 'rejected')
                    <form action="{{ route('tasks.start', $task) }}" method="POST">
                        @csrf @method('PATCH')
                        <button class="btn btn-primary">
                            <i class="bi bi-arrow-repeat me-1"></i>Re-start Task
                        </button>
                    </form>
                    @endif
                @endif

                @if(auth()->user()->canApprove() && $task->status === 'under_review')
                <!-- Approve Modal Trigger -->
                <button class="btn btn-success" data-bs-toggle="modal" data-bs-target="#approveModal">
                    <i class="bi bi-check-circle me-1"></i>Approve Task
                </button>
                <button class="btn btn-danger" data-bs-toggle="modal" data-bs-target="#rejectModal">
                    <i class="bi bi-x-circle me-1"></i>Reject Task
                </button>
                @endif

                @if(!in_array($task->status, ['approved', 'completed']))
                <a href="{{ route('tasks.edit', $task) }}" class="btn btn-outline-secondary">
                    <i class="bi bi-pencil me-1"></i>Edit
                </a>
                @endif

                <a href="{{ route('tasks.index') }}" class="btn btn-outline-secondary ms-auto">
                    <i class="bi bi-arrow-left me-1"></i>Back to Tasks
                </a>
            </div>
        </div>
    </div>

    <!-- Task Log / History -->
    <div class="col-md-4">
        <div class="card">
            <div class="card-header py-3">
                <i class="bi bi-clock-history me-2 text-info"></i>Activity Log
            </div>
            <div class="card-body p-0" style="max-height:500px;overflow-y:auto;">
                @forelse($task->logs as $log)
                <div class="d-flex gap-3 p-3 border-bottom">
                    <div class="flex-shrink-0">
                        <span class="badge bg-{{ $log->actionBadge() }}" style="width:12px;height:12px;border-radius:50%;padding:0;">&nbsp;</span>
                    </div>
                    <div>
                        <div class="fw-semibold small">{{ $log->actionLabel() }}</div>
                        <div class="text-muted" style="font-size:0.75rem;">
                            By <strong>{{ $log->user->name }}</strong>
                        </div>
                        @if($log->note)
                        <div class="text-muted" style="font-size:0.75rem;">{{ $log->note }}</div>
                        @endif
                        <div class="text-muted" style="font-size:0.7rem;">{{ $log->created_at->diffForHumans() }}</div>
                    </div>
                </div>
                @empty
                <div class="text-center py-4 text-muted small">No activity yet.</div>
                @endforelse
            </div>
        </div>

        <!-- Approval History -->
        @if($task->approvals->count() > 0)
        <div class="card mt-3">
            <div class="card-header py-3">
                <i class="bi bi-clipboard-check me-2 text-success"></i>Approval History
            </div>
            <div class="card-body p-0">
                @foreach($task->approvals as $approval)
                <div class="p-3 border-bottom">
                    <div class="d-flex justify-content-between">
                        <span class="badge bg-{{ $approval->status === 'approved' ? 'success' : 'danger' }}">
                            {{ ucfirst($approval->status) }}
                        </span>
                        <small class="text-muted">{{ $approval->created_at->format('d M Y') }}</small>
                    </div>
                    <div class="small mt-1">By: <strong>{{ $approval->reviewer->name }}</strong></div>
                    @if($approval->comment)
                    <div class="text-muted small mt-1">{{ $approval->comment }}</div>
                    @endif
                </div>
                @endforeach
            </div>
        </div>
        @endif
    </div>
</div>

<!-- Approve Modal -->
@if(auth()->user()->canApprove())
<div class="modal fade" id="approveModal" tabindex="-1">
    <div class="modal-dialog">
        <form action="{{ route('approvals.approve', $task) }}" method="POST">
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><i class="bi bi-check-circle text-success me-2"></i>Approve Task</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <p>You are about to approve: <strong>{{ $task->title }}</strong></p>
                    <div class="mb-3">
                        <label class="form-label">Comment (optional)</label>
                        <textarea name="comment" class="form-control" rows="3" placeholder="Add a comment..."></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-success">
                        <i class="bi bi-check-circle me-1"></i>Approve
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Reject Modal -->
<div class="modal fade" id="rejectModal" tabindex="-1">
    <div class="modal-dialog">
        <form action="{{ route('approvals.reject', $task) }}" method="POST">
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><i class="bi bi-x-circle text-danger me-2"></i>Reject Task</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <p>You are about to reject: <strong>{{ $task->title }}</strong></p>
                    <div class="mb-3">
                        <label class="form-label fw-semibold">Rejection Reason <span class="text-danger">*</span></label>
                        <textarea name="comment" class="form-control" rows="3"
                                  placeholder="Explain why this task is rejected..." required></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-danger">
                        <i class="bi bi-x-circle me-1"></i>Reject Task
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>
@endif
@endsection
