@extends('layouts.app')
@section('title', 'Team Members')
@section('page-title', 'Team Members')

@section('content')
<div class="card">
    <div class="card-header py-3 d-flex justify-content-between align-items-center">
        <span><i class="bi bi-people me-2 text-primary"></i>Team Members</span>
        @if(auth()->user()->isSuperAdmin())
        <a href="{{ route('users.create') }}" class="btn btn-primary btn-sm">
            <i class="bi bi-person-plus me-1"></i> Add Member
        </a>
        @endif
    </div>

    <div class="card-body border-bottom py-3">
        <form method="GET" class="row g-2">
            <div class="col-md-4">
                <input type="text" name="search" class="form-control form-control-sm"
                       placeholder="Search by name or email..." value="{{ request('search') }}">
            </div>
            <div class="col-md-3">
                <select name="role" class="form-select form-select-sm">
                    <option value="">All Roles</option>
                    @if(!auth()->user()->isSuperAdmin())
                    <option value="super_admin" {{ request('role') === 'super_admin' ? 'selected' : '' }}>Super Admin</option>
                    <option value="admin"       {{ request('role') === 'admin' ? 'selected' : '' }}>Admin</option>
                    @endif
                    <option value="marketing"   {{ request('role') === 'marketing' ? 'selected' : '' }}>Marketing</option>
                    <option value="designer"    {{ request('role') === 'designer' ? 'selected' : '' }}>Designer</option>
                    <option value="developer"   {{ request('role') === 'developer' ? 'selected' : '' }}>Developer</option>
                </select>
            </div>
            <div class="col-md-2">
                <button type="submit" class="btn btn-secondary btn-sm">
                    <i class="bi bi-funnel me-1"></i>Filter
                </button>
            </div>
        </form>
    </div>

    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table mb-0">
                <thead>
                    <tr>
                        <th class="ps-3">Member</th>
                        <th>Email</th>
                        <th>Role</th>
                        <th>Phone</th>
                        <th>Status</th>
                        <th>Joined</th>
                        @if(auth()->user()->isSuperAdmin())
                        <th>Actions</th>
                        @endif
                    </tr>
                </thead>
                <tbody>
                    @forelse($users as $user)
                    <tr>
                        <td class="ps-3">
                            <div class="d-flex align-items-center gap-2">
                                <div class="avatar role-{{ $user->role }}" style="background:none;border:2px solid;">
                                    {{ strtoupper(substr($user->name, 0, 1)) }}
                                </div>
                                <div>
                                    <div class="fw-semibold small">{{ $user->name }}</div>
                                    @if($user->username)
                                    <div class="text-muted" style="font-size:0.75rem;">{{ $user->username }}</div>
                                    @endif
                                </div>
                            </div>
                        </td>
                        <td><small>{{ $user->email }}</small></td>
                        <td>
                            <span class="role-badge role-{{ $user->role }}">
                                {{ str_replace('_', ' ', $user->role) }}
                            </span>
                        </td>
                        <td><small class="text-muted">{{ $user->phone ?? '—' }}</small></td>
                        <td>
                            <span class="badge bg-{{ $user->status === 'active' ? 'success' : 'danger' }}">
                                {{ ucfirst($user->status) }}
                            </span>
                        </td>
                        <td><small class="text-muted">{{ $user->created_at->format('d M Y') }}</small></td>
                        @if(auth()->user()->isSuperAdmin())
                        <td>
                            <div class="d-flex gap-1">
                                <a href="{{ route('users.edit', $user) }}" class="btn btn-sm btn-outline-warning" title="Edit">
                                    <i class="bi bi-pencil"></i>
                                </a>
                                @if($user->id !== auth()->id())
                                <form action="{{ route('users.destroy', $user) }}" method="POST"
                                      onsubmit="return confirm('Delete {{ $user->name }}? This cannot be undone.')">
                                    @csrf @method('DELETE')
                                    <button class="btn btn-sm btn-outline-danger" title="Delete">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </form>
                                @endif
                            </div>
                        </td>
                        @endif
                    </tr>
                    @empty
                    <tr>
                        <td colspan="7" class="text-center py-5 text-muted">No members found.</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
    @if($users->hasPages())
    <div class="card-footer">{{ $users->links() }}</div>
    @endif
</div>
@endsection
